@extends('layouts.admin')

@section('title', 'News Post')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h3">News Posts</h1>
        <a href="{{ route('admin.news.create') }}" class="btn btn-primary">Add New Post</a>
    </div>

    <div class="card">
        <table class="table table-hover my-0">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Status</th>
                    <th>Published At</th>
                    <th class="text-end">Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($posts as $post)
                    <tr>
                        <td>{{ $post->title }}</td>
                        <td>
                            <span class="badge {{ $post->status == 'published' ? 'bg-success' : 'bg-secondary' }}">
                                {{ ucfirst($post->status) }}
                            </span>
                        </td>
                        <td>{{ \Carbon\Carbon::parse($post->published_at)->format('M d, Y') }}</td>
                        <td class="text-end">
                            <a href="{{ route('admin.news.edit', $post->id) }}" class="btn btn-sm btn-primary">Edit</a>
                            <form action="{{ route('admin.news.destroy', $post->id) }}" method="POST" class="d-inline-block">
                                @csrf @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger"
                                    onclick="return confirm('Are you sure?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection