@extends('layouts.admin')

@section('title', isset($post) ? 'Edit News' : 'Create News')

@section('content')
    <h1 class="h3 mb-3">{{ isset($post) ? 'Edit News' : 'Create News' }}</h1>

    <form action="{{ isset($post) ? route('admin.news.update', $post->id) : route('admin.news.store') }}" method="POST"
        enctype="multipart/form-data">
        @csrf
        @if(isset($post)) @method('PUT') @endif

        <div class="row">
            <div class="col-md-8">
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Title</label>
                            <input type="text" class="form-control" name="title" value="{{ $post->title ?? '' }}" required>
                        </div>
                        <div class="mb-3">
                            <label for="content" class="form-label">Content</label>
                            <textarea class="form-control rich-text-editor" id="content" name="content" rows="10"
                                required>{{ old('content', $post->content ?? '') }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card mb-3">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Publishing</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status">
                                <option value="draft" {{ (isset($post) && $post->status == 'draft') ? 'selected' : '' }}>Draft
                                </option>
                                <option value="published" {{ (isset($post) && $post->status == 'published') ? 'selected' : '' }}>Published</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Date</label>
                            <input type="datetime-local" class="form-control" name="published_at"
                                value="{{ isset($post->published_at) ? \Carbon\Carbon::parse($post->published_at)->format('Y-m-d\TH:i') : now()->format('Y-m-d\TH:i') }}">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Featured Image</label>
                            <div class="input-group mb-2">
                                <input type="text" name="featured_image" id="featured_image" class="form-control"
                                    value="{{ $post->featured_image ?? '' }}" placeholder="Select path or upload new"
                                    readonly>
                                <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                    data-bs-target="#mediaLibraryModal" data-input-target="#featured_image"
                                    data-preview-target="#featured_image_preview">Select from Library</button>
                            </div>
                            <input type="file" class="form-control" name="featured_image_file">
                            <div class="form-text">Upload a new file to replace the current one.</div>
                            <div id="featured_image_preview" class="mt-2">
                                @if(isset($post->featured_image))
                                    <img src="{{ asset($post->featured_image) }}" class="mt-2 img-fluid">
                                @endif
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Company/Partner Logo (Optional)</label>
                            <div class="input-group mb-2">
                                <input type="text" name="logo" id="logo" class="form-control"
                                    value="{{ $post->logo ?? '' }}" placeholder="Select logo from library" readonly>
                                <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                    data-bs-target="#mediaLibraryModal" data-input-target="#logo"
                                    data-preview-target="#logo_preview">Select</button>
                            </div>
                            <div id="logo_preview" class="mt-2">
                                @if(isset($post->logo))
                                    <img src="{{ asset($post->logo) }}" class="mt-2" style="max-height: 80px;">
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                <div class="d-grid">
                    <button type="submit" class="btn btn-primary">Save Post</button>
                </div>
            </div>
        </div>
    </form>

    @push('scripts')
        <script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script>
        <script>
            ClassicEditor.create(document.querySelector('#editor')).catch(error => { console.error(error); });
        </script>
    @endpush
@endsection
@include('admin.media.modal')