<li class="list-group-item menu-item" data-id="{{ $item->id }}">
    <div class="d-flex justify-content-between align-items-center">
        <div class="d-flex align-items-center">
            <i data-feather="move" class="handle me-2 text-muted cursor-move"></i>
            <span class="item-title fw-bold">
                {{ $item->page_id ? ($item->page->title . ' (Page)') : $item->title }}
            </span>
            <small class="text-muted ms-2 url-preview">
                ({{ $item->page_id ? url($item->page->slug) : ($item->url ?? 'No URL') }})
            </small>
        </div>
        <div>
            <button class="btn btn-sm btn-link text-primary edit-item-btn" data-id="{{ $item->id }}"
                data-title="{{ $item->title }}" data-url="{{ $item->page_id ? url($item->page->slug) : $item->url }}"
                data-target="{{ $item->target }}">Edit</button>
            <button class="btn btn-sm btn-link text-danger delete-item-btn" data-id="{{ $item->id }}">Delete</button>
        </div>
    </div>

    {{-- Edit Form (Hidden) --}}
    <div class="item-settings mt-2 p-2 bg-light border rounded d-none" id="settings-{{ $item->id }}">
        <div class="row g-2">
            <div class="col-md-6">
                <label class="small">Title</label>
                <input type="text" class="form-control form-control-sm edit-title" value="{{ $item->title }}">
                @if($item->page_id)
                    <small class="text-muted d-block mt-1">Linked to Page: <strong>{{ $item->page->title }}</strong></small>
                @endif
            </div>
            <div class="col-md-6">
                <label class="small">URL</label>
                <input type="text" class="form-control form-control-sm edit-url"
                    value="{{ $item->page_id ? url($item->page->slug) : $item->url }}" {{ $item->page_id ? 'readonly disabled' : '' }}>
                @if($item->page_id)
                    <small class="text-muted d-block mt-1">Auto-updated from Page Slug</small>
                @endif
            </div>
            <div class="col-md-4">
                <label class="small">Target</label>
                <select class="form-select form-select-sm edit-target">
                    <option value="_self" {{ $item->target == '_self' ? 'selected' : '' }}>Same Tab</option>
                    <option value="_blank" {{ $item->target == '_blank' ? 'selected' : '' }}>New Tab</option>
                </select>
            </div>
            <div class="col-12 text-end">
                <button class="btn btn-sm btn-success save-item-btn" data-id="{{ $item->id }}">Update</button>
            </div>
        </div>
    </div>

    {{-- Nested Children --}}
    <ul class="list-group nested-sortable mt-2 min-h-10">
        @if($item->children && $item->children->count())
            @each('admin.menus.item', $item->children, 'item')
        @endif
    </ul>
</li>