@extends('layouts.admin')

@section('content')
    <div class="container-fluid p-0">
        <div class="row mb-2 mb-xl-3">
            <div class="col-auto">
                <h3>Menu Builder: <strong>{{ $menu->name }}</strong></h3>
            </div>
            <div class="col-auto ms-auto text-end mt-n1">
                <button class="btn btn-success" id="save-menu-btn"><i data-feather="save"></i> Save Structure</button>
                <a href="{{ route('admin.menus.index') }}" class="btn btn-secondary">Back</a>
            </div>
        </div>

        <div class="row">
            {{-- Left: Add Items --}}
            <div class="col-md-4">
                {{-- Add Custom Link --}}
                <div class="card mb-3">
                    <div class="card-header bg-light cursor-pointer" data-bs-toggle="collapse" data-bs-target="#addCustom">
                        <h5 class="card-title mb-0">Custom Link</h5>
                    </div>
                    <div class="collapse show" id="addCustom">
                        <div class="card-body">
                            <div class="mb-2">
                                <label class="form-label">URL</label>
                                <input type="text" id="custom-url" class="form-control" placeholder="http://">
                            </div>
                            <div class="mb-2">
                                <label class="form-label">Link Text</label>
                                <input type="text" id="custom-text" class="form-control" placeholder="Menu Item">
                            </div>
                            <button class="btn btn-primary btn-sm w-100 add-to-menu-btn" data-type="custom">Add to
                                Menu</button>
                        </div>
                    </div>
                </div>

                {{-- Add Pages --}}
                <div class="card mb-3">
                    <div class="card-header bg-light cursor-pointer" data-bs-toggle="collapse" data-bs-target="#addPages">
                        <h5 class="card-title mb-0">Pages</h5>
                    </div>
                    <div class="collapse" id="addPages">
                        <div class="card-body" style="max-height: 200px; overflow-y: auto;">
                            @foreach($pages as $page)
                                <div class="form-check">
                                    <input class="form-check-input page-checkbox" type="checkbox"
                                        value="{{ url($page->slug == 'home' ? '/' : $page->slug) }}"
                                        data-text="{{ $page->title }}" data-page-id="{{ $page->id }}">
                                    <label class="form-check-label">{{ $page->title }}</label>
                                </div>
                            @endforeach
                            <button class="btn btn-primary btn-sm w-100 mt-2 add-to-menu-btn" data-type="pages">Add
                                Selected</button>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Right: Builder --}}
            <div class="col-md-8">
                <div class="card">
                    <div class="card-body">
                        <p class="text-muted small">Drag and drop items to reorder. Drag to the right to nest them as
                            sub-items.</p>
                        <ul id="menu-root" class="list-group nested-sortable">
                            @each('admin.menus.item', $menu->rootItems, 'item')
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            document.addEventListener("DOMContentLoaded", function () {
                // --- SortableJS Initialization ---
                var nestedSortables = [].slice.call(document.querySelectorAll('.nested-sortable'));

                function initSortable(el) {
                    new Sortable(el, {
                        group: 'nested',
                        animation: 150,
                        fallbackOnBody: true,
                        swapThreshold: 0.65,
                        handle: '.handle'
                    });
                }

                nestedSortables.forEach(initSortable);

                // --- Add Items ---
                const addToMenuBtns = document.querySelectorAll('.add-to-menu-btn');
                addToMenuBtns.forEach(btn => {
                    btn.addEventListener('click', function () {
                        const type = this.getAttribute('data-type');
                        let itemsToAdd = [];

                        if (type === 'custom') {
                            const url = document.getElementById('custom-url').value;
                            const text = document.getElementById('custom-text').value;
                            if (text) itemsToAdd.push({ title: text, url: url, target: '_self' });
                            // Clear inputs
                            document.getElementById('custom-url').value = '';
                            document.getElementById('custom-text').value = '';
                        } else if (type === 'pages') {
                            document.querySelectorAll('.page-checkbox:checked').forEach(chk => {
                                itemsToAdd.push({
                                    title: chk.getAttribute('data-text'),
                                    url: chk.value,
                                    page_id: chk.getAttribute('data-page-id'),
                                    target: '_self'
                                });
                                chk.checked = false;
                            });
                        }

                        if (itemsToAdd.length > 0) {
                            itemsToAdd.forEach(itemData => {
                                // AJAX Call to create item immediately
                                fetch(`{{ route('admin.menus.store-item', $menu->id) }}`, {
                                    method: 'POST',
                                    headers: {
                                        'Content-Type': 'application/json',
                                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                                    },
                                    body: JSON.stringify(itemData)
                                })
                                    .then(response => response.json())
                                    .then(data => {
                                        if (data.status === 'success') {
                                            // Reload page to render new item (simplest for recursive blade)
                                            // Ideally, append HTML via JS, but sticking to reload for robustness with recursive partials
                                            window.location.reload();
                                        }
                                    });
                            });
                        }
                    });
                });

                // --- Toggle Edit ---
                document.body.addEventListener('click', function (e) {
                    if (e.target.classList.contains('edit-item-btn')) {
                        const id = e.target.getAttribute('data-id');
                        const settingsDiv = document.getElementById('settings-' + id);
                        settingsDiv.classList.toggle('d-none');
                    }
                });

                // --- Save Item Updates ---
                document.body.addEventListener('click', function (e) {
                    if (e.target.classList.contains('save-item-btn')) {
                        const id = e.target.getAttribute('data-id');
                        const container = document.getElementById('settings-' + id);
                        const title = container.querySelector('.edit-title').value;
                        const url = container.querySelector('.edit-url').value;
                        const target = container.querySelector('.edit-target').value;

                        fetch(`/admin/menus/items/${id}`, {
                            method: 'POST', // Using POST for update route if not PUT
                            headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
                            body: JSON.stringify({ title, url, target, _method: 'PUT' })
                        }).then(() => {
                            showToast('Item updated');
                            container.classList.add('d-none');
                            // Update text in UI
                            container.closest('li').querySelector('.item-title').textContent = title;
                        });
                    }
                });

                // --- Delete Item ---
                document.body.addEventListener('click', function (e) {
                    if (e.target.classList.contains('delete-item-btn')) {
                        if (confirm('Delete this item?')) {
                            const id = e.target.getAttribute('data-id');
                            fetch(`/admin/menus/items/${id}`, {
                                method: 'DELETE',
                                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' }
                            }).then(() => {
                                e.target.closest('li').remove();
                            });
                        }
                    }
                });

                // --- Save Structure ---
                document.getElementById('save-menu-btn').addEventListener('click', function () {
                    const structure = serializeList(document.getElementById('menu-root'));

                    fetch(`{{ route('admin.menus.update-structure', $menu->id) }}`, {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
                        body: JSON.stringify({ structure: structure })
                    }).then(() => {
                        showToast('Menu structure saved successfully.');
                    });
                });

                function serializeList(list) {
                    let data = [];
                    // Direct children only
                    Array.from(list.children).forEach(li => {
                        if (li.classList.contains('menu-item')) {
                            let item = {
                                id: li.getAttribute('data-id'),
                                children: []
                            };
                            let childUl = li.querySelector('ul.nested-sortable');
                            if (childUl && childUl.children.length > 0) {
                                item.children = serializeList(childUl);
                            }
                            data.push(item);
                        }
                    });
                    return data;
                }

            });
        </script>
        <style>
            .cursor-pointer {
                cursor: pointer;
            }

            .cursor-move {
                cursor: move;
            }

            .menu-item {
                background: #fff;
                border: 1px solid #ddd;
                margin-bottom: 5px;
            }

            .nested-sortable {
                min-height: 20px;
                padding-left: 20px;
                list-style: none;
                border: 1px dashed #e5e5e5;
                /* Visual cue for drop zone */
                border-radius: 4px;
                margin-top: 5px;
            }

            .min-h-10 {
                min-height: 10px;
            }
        </style>
    @endpush
@endsection