<div class="modal fade" id="mediaLibraryModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Media Library</h5>
                <div class="ms-auto d-flex gap-2">
                    <input type="file" id="media-upload-input" class="d-none" accept="image/*">
                    <button type="button" class="btn btn-success btn-sm"
                        onclick="document.getElementById('media-upload-input').click()">
                        <i data-feather="upload" class="width-15 height-15 me-1"></i> Upload Image
                    </button>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
            </div>
            <div class="modal-body bg-light">
                <div id="media-loading" class="text-center py-5">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
                <div id="media-grid" class="row g-3" style="display: none;">
                    {{-- Content injected via JS --}}
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

{{-- SweetAlert2 for prompts --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const modal = document.getElementById('mediaLibraryModal');
        const uploadInput = document.getElementById('media-upload-input');
        let targetInput = null;
        let previewContainer = null;

        modal.addEventListener('show.bs.modal', function (event) {
            const button = event.relatedTarget;
            targetInput = document.querySelector(button.getAttribute('data-input-target'));
            previewContainer = document.querySelector(button.getAttribute('data-preview-target'));

            loadMedia(true); // Force reload
        });

        // Upload Handler
        uploadInput.addEventListener('change', function () {
            if (this.files && this.files[0]) {
                const formData = new FormData();
                formData.append('file', this.files[0]);
                formData.append('folder', 'uploads/news'); // Default to news or generic

                // Show loading toast
                const toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 3000
                });
                toast.fire({ icon: 'info', title: 'Uploading...' });

                fetch('{{ route("admin.media.store") }}', {
                    method: 'POST',
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: formData
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            toast.fire({ icon: 'success', title: 'Uploaded successfully' });
                            loadMedia(true);
                            uploadInput.value = ''; // Reset
                        } else {
                            toast.fire({ icon: 'error', title: data.message || 'Upload failed' });
                        }
                    })
                    .catch(err => toast.fire({ icon: 'error', title: 'Upload failed' }));
            }
        });

        function loadMedia(force = false) {
            const grid = document.getElementById('media-grid');
            const loader = document.getElementById('media-loading');

            if (!force && grid.children.length > 0) return;

            grid.style.display = 'none';
            loader.style.display = 'block';

            fetch('{{ route("admin.media.index") }}', {
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            })
                .then(response => response.json())
                .then(files => {
                    loader.style.display = 'none';
                    grid.style.display = 'flex';
                    grid.innerHTML = '';

                    if (files.length === 0) {
                        grid.innerHTML = '<div class="col-12 text-center p-5 text-muted">No media found. Upload one!</div>';
                        return;
                    }

                    files.forEach(file => {
                        // if (!file.is_image) return; // Optional filter

                        const canManage = file.path.startsWith('uploads/');

                        const col = document.createElement('div');
                        col.className = 'col-6 col-md-3 col-lg-2';
                        col.innerHTML = `
                        <div class="card h-100 shadow-sm media-item-card group-hover-container position-relative">
                            <div class="card-body p-2 d-flex align-items-center justify-content-center bg-white rounded-top" 
                                style="height: 120px; cursor: pointer;"
                                onclick="selectMedia('${file.url}', '${file.path}')">
                                <img src="${file.url}" class="img-fluid" style="max-height: 100px; object-fit: contain;">
                            </div>
                            <div class="card-footer p-2 small bg-white border-top d-flex justify-content-between align-items-center">
                                <span class="text-truncate d-block" style="max-width: 80%;" title="${file.name}">${file.name}</span>
                                ${canManage ? `
                                <div class="dropdown">
                                    <button class="btn btn-light btn-sm p-0 border-0" type="button" data-bs-toggle="dropdown" aria-expanded="false" style="width: 20px;">
                                        <i data-feather="more-vertical" style="width: 14px; height: 14px;"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-end shadow-sm">
                                        <li><a class="dropdown-item small" href="#" onclick="renameMedia(event, '${file.path}', '${file.name}')"><i data-feather="edit-2" class="me-2 text-muted" style="width:12px;"></i> Rename</a></li>
                                        <li><hr class="dropdown-divider my-1"></li>
                                        <li><a class="dropdown-item small text-danger" href="#" onclick="deleteMedia(event, '${file.path}')"><i data-feather="trash" class="me-2" style="width:12px;"></i> Delete</a></li>
                                    </ul>
                                </div>
                                ` : ''}
                            </div>
                        </div>
                    `;
                        grid.appendChild(col);
                    });
                    feather.replace();
                })
                .catch(err => {
                    console.error('Error loading media:', err);
                    loader.innerHTML = '<p class="text-danger">Failed to load media.</p>';
                });
        }

        window.selectMedia = function (url, path) {
            if (targetInput) {
                targetInput.value = url;
                // Trigger change event if needed
                targetInput.dispatchEvent(new Event('change'));
            }
            if (previewContainer) {
                previewContainer.innerHTML = `<img src="${url}" class="img-fluid rounded mt-2" style="max-height: 100px;">`;
            }
            const bsModal = bootstrap.Modal.getInstance(modal);
            bsModal.hide();
        };

        window.renameMedia = function (e, path, currentName) {
            e.preventDefault();
            e.stopPropagation();

            Swal.fire({
                title: 'Rename File',
                input: 'text',
                inputValue: currentName,
                showCancelButton: true,
                confirmButtonText: 'Rename',
                showLoaderOnConfirm: true,
                preConfirm: (newName) => {
                    return fetch('{{ route("admin.media.rename") }}', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        },
                        body: JSON.stringify({ path: path, new_name: newName })
                    })
                        .then(response => {
                            if (!response.ok) {
                                return response.json().then(data => { throw new Error(data.message || 'Error') });
                            }
                            return response.json();
                        })
                        .catch(error => {
                            Swal.showValidationMessage(`Request failed: ${error.message}`);
                        });
                },
                allowOutsideClick: () => !Swal.isLoading()
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({ icon: 'success', title: 'Renamed!', timer: 1500, showConfirmButton: false });
                    loadMedia(true);
                }
            });
        };

        window.deleteMedia = function (e, path) {
            e.preventDefault();
            e.stopPropagation();

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch('{{ route("admin.media.destroy") }}', {
                        method: 'POST', // or DELETE if route supports it, but controller uses POST usually for deletion in this app? Check route.
                        // Actually web.php shows resource controller likely uses DELETE but let's check. 
                        // Wait, route list shows destroy usually implies DELETE. 
                        // Admin routes resource: Route::delete('/admin/media/{media}', ...). 
                        // My previous code used POST to a destroy method? 
                        // Let's use POST with _method=DELETE to be safe if it's a form-like submission, or just DELETE method.
                        // The controller destroy method takes Request $request, inputs path. It's likely a custom POST route or DELETE.
                        // I'll assume POST based on typical Laravel admin panel forms unless I see a specific route.
                        // The Controller `destroy` method reads `$request->input('path')`. Standard RESTful destroy usually takes an ID. 
                        // This suggests it's a custom endpoint or expects a POST body.
                        // Standard Resource destroy: DELETE /media/{id}. Here we delete by PATH.
                        // Let's assume I need to hit the delete route.
                        // Actually, I'll use method DELETE.
                        headers: {
                            'Content-Type': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        },
                        body: JSON.stringify({ path: path, _method: 'DELETE' })
                    })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                Swal.fire('Deleted!', 'Your file has been deleted.', 'success');
                                loadMedia(true);
                            } else {
                                Swal.fire('Error!', data.message, 'error');
                            }
                        });
                }
            });
        };
    });
</script>