@extends('layouts.admin')

@section('title', 'Dashboard')

@section('content')
    <div class="container-fluid p-0">
        <div class="mb-3">
            <h1 class="h3 d-inline align-middle">Dashboard Overview</h1>
        </div>

        <div class="row">
            <div class="col-12 col-sm-6 col-xxl-3 d-flex">
                <div class="card flex-fill">
                    <div class="card-body py-4">
                        <div class="d-flex align-items-start">
                            <div class="flex-grow-1">
                                <h3 class="mb-2">Total Companies</h3>
                                <div class="mb-0">
                                    <span class="badge bg-soft-success text-success">Live</span>
                                    <span class="text-muted">Registered</span>
                                </div>
                            </div>
                            <div class="d-inline-block ms-3">
                                <div class="stat text-primary bg-primary-light">
                                    <i class="align-middle" data-feather="briefcase"></i>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mt-3">
                            <h2 class="mb-0 font-weight-bold">{{ $counts['portfolio'] }}</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-xxl-3 d-flex">
                <div class="card flex-fill">
                    <div class="card-body py-4">
                        <div class="d-flex align-items-start">
                            <div class="flex-grow-1">
                                <h3 class="mb-2">Team Members</h3>
                                <div class="mb-0">
                                    <span class="badge bg-soft-info text-info">Active</span>
                                    <span class="text-muted">On Board</span>
                                </div>
                            </div>
                            <div class="d-inline-block ms-3">
                                <div class="stat text-info bg-info-light">
                                    <i class="align-middle" data-feather="users"></i>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mt-3">
                            <h2 class="mb-0 font-weight-bold">{{ $counts['team'] }}</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-xxl-3 d-flex">
                <div class="card flex-fill">
                    <div class="card-body py-4">
                        <div class="d-flex align-items-start">
                            <div class="flex-grow-1">
                                <h3 class="mb-2">Recent News</h3>
                                <div class="mb-0">
                                    <span class="badge bg-soft-warning text-warning">Published</span>
                                    <span class="text-muted">Articles</span>
                                </div>
                            </div>
                            <div class="d-inline-block ms-3">
                                <div class="stat text-warning bg-warning-light">
                                    <i class="align-middle" data-feather="file-text"></i>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mt-3">
                            <h2 class="mb-0 font-weight-bold">{{ $counts['news'] }}</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-xxl-3 d-flex">
                <div class="card flex-fill">
                    <div class="card-body py-4">
                        <div class="d-flex align-items-start">
                            <div class="flex-grow-1">
                                <h3 class="mb-2">Applications</h3>
                                <div class="mb-0">
                                    <span class="badge bg-soft-danger text-danger">New</span>
                                    <span class="text-muted">In Inbox</span>
                                </div>
                            </div>
                            <div class="d-inline-block ms-3">
                                <div class="stat text-danger bg-danger-light">
                                    <i class="align-middle" data-feather="inbox"></i>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mt-3">
                            <h2 class="mb-0 font-weight-bold">{{ $counts['applications'] }}</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12 col-lg-8 d-flex">
                <div class="card flex-fill w-100">
                    <div class="card-header">
                        <div class="card-actions float-end">
                            <select class="form-select form-select-sm" aria-label=".form-select-sm example">
                                <option selected="">Last 7 Days</option>
                                <option value="1">Last 30 Days</option>
                                <option value="2">Last Year</option>
                            </select>
                        </div>
                        <h5 class="card-title mb-0">Analytics</h5>
                    </div>
                    <div class="card-body p-2">
                        <div
                            style="height: 300px; display: flex; align-items: center; justify-content: center; background: #f8f9fa; color: #adb5bd;">
                            Chart Placeholder (Need Chart.js)
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-4 d-flex">
                <div class="card flex-fill w-100">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Recent Activity</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-start">
                            <img src="https://ui-avatars.com/api/?name=Admin&background=random" width="36" height="36"
                                class="rounded-circle me-2" alt="Admin">
                            <div class="flex-grow-1">
                                <small class="float-end text-navy">5m ago</small>
                                <strong>Admin</strong> started following <strong>Tamio Capital</strong><br>
                                <small class="text-muted">Today 7:51 pm</small><br>
                            </div>
                        </div>
                        <hr>
                        <div class="d-flex align-items-start">
                            <img src="https://ui-avatars.com/api/?name=User&background=random" width="36" height="36"
                                class="rounded-circle me-2" alt="User">
                            <div class="flex-grow-1">
                                <small class="float-end text-navy">30m ago</small>
                                <strong>New Application</strong> received from <strong>John Doe</strong><br>
                                <small class="text-muted">Today 7:21 pm</small><br>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer text-center">
                        <a href="#" class="text-muted">View All History</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .stat {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            border-radius: 50%;
        }

        .bg-soft-success {
            background-color: rgba(76, 175, 80, 0.1) !important;
        }

        .bg-soft-info {
            background-color: rgba(0, 188, 212, 0.1) !important;
        }

        .bg-soft-warning {
            background-color: rgba(255, 193, 7, 0.1) !important;
        }

        .bg-soft-danger {
            background-color: rgba(244, 67, 54, 0.1) !important;
        }

        .bg-primary-light {
            background-color: rgba(59, 125, 221, 0.1);
        }

        .bg-info-light {
            background-color: rgba(23, 162, 184, 0.1);
        }

        .bg-warning-light {
            background-color: rgba(255, 193, 7, 0.1);
        }

        .bg-danger-light {
            background-color: rgba(220, 53, 69, 0.1);
        }
    </style>
@endsection