@extends('layouts.admin')

@section('title', 'Job Openings')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h3">Job Openings</h1>
        <a href="{{ route('admin.careers.jobs.create') }}" class="btn btn-primary">Add New Job</a>
    </div>

    <div class="card">
        <table class="table table-hover my-0">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Department</th>
                    <th>Location</th>
                    <th>Status</th>
                    <th class="text-end">Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($jobs as $job)
                    <tr>
                        <td>{{ $job->title }}</td>
                        <td>{{ $job->department }}</td>
                        <td>{{ $job->location }}</td>
                        <td>
                            <span class="badge {{ $job->is_active ? 'bg-success' : 'bg-danger' }}">
                                {{ $job->is_active ? 'Active' : 'Closed' }}
                            </span>
                        </td>
                        <td class="text-end">
                            <a href="{{ route('admin.careers.jobs.edit', $job->id) }}" class="btn btn-sm btn-primary">Edit</a>
                            <form action="{{ route('admin.careers.jobs.destroy', $job->id) }}" method="POST"
                                class="d-inline-block">
                                @csrf @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger"
                                    onclick="return confirm('Are you sure?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection