@extends('layouts.admin')

@section('title', isset($job) ? 'Edit Job' : 'Post Job')

@section('content')
    <h1 class="h3 mb-3">{{ isset($job) ? 'Edit Job' : 'Post New Job' }}</h1>

    <form action="{{ isset($job) ? route('admin.careers.jobs.update', $job->id) : route('admin.careers.jobs.store') }}"
        method="POST">
        @csrf
        @if(isset($job)) @method('PUT') @endif

        <div class="row">
            <div class="col-md-8">
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Job Title</label>
                            <input type="text" class="form-control" name="title" value="{{ $job->title ?? '' }}" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description"
                                rows="5">{{ $job->description ?? '' }}</textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Requirements</label>
                            <textarea class="form-control" name="requirements"
                                rows="5">{{ $job->requirements ?? '' }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="is_active">
                                <option value="1" {{ (isset($job) && $job->is_active) ? 'selected' : '' }}>Active (Open)
                                </option>
                                <option value="0" {{ (isset($job) && !$job->is_active) ? 'selected' : '' }}>Closed</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Department</label>
                            <input type="text" class="form-control" name="department" value="{{ $job->department ?? '' }}">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Location</label>
                            <input type="text" class="form-control" name="location" value="{{ $job->location ?? '' }}">
                        </div>
                    </div>
                </div>
                <div class="d-grid">
                    <button type="submit" class="btn btn-primary">Save Job</button>
                </div>
            </div>
        </div>
    </form>
@endsection