@extends('layouts.admin')

@section('title', 'Job Applications')

@section('content')
    <h1 class="h3 mb-3">Job Applications</h1>

    <div class="card">
        <table class="table table-hover my-0">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Position</th>
                    <th>Email</th>
                    <th>Applied Date</th>
                    <th>CV</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($applications as $app)
                    <tr>
                        <td>{{ $app->full_name }}</td>
                        <td>{{ $app->job_title ?? 'General Application' }}</td>
                        <td>{{ $app->email }}</td>
                        <td>{{ \Carbon\Carbon::parse($app->created_at)->format('M d, Y') }}</td>
                        <td>
                            <a href="{{ $app->cv_path }}" target="_blank" class="btn btn-sm btn-outline-primary">View CV</a>
                        </td>
                        <td><span class="badge bg-secondary">{{ ucfirst($app->status) }}</span></td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection