<?php

use App\Models\PageSection;

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

$sections = PageSection::where('page_id', 1)->orderBy('order')->get();

echo "Current Order:\n";
foreach ($sections as $s) {
    echo "{$s->section_identifier}: {$s->order}\n";
}

$news = $sections->firstWhere('section_identifier', 'home_news');
$newsletter = $sections->firstWhere('section_identifier', 'home_newsletter');

if ($news && $newsletter && $news->order > $newsletter->order) {
    echo "\nSwapping order...\n";
    $temp = $news->order;
    $news->order = $newsletter->order;
    $newsletter->order = $temp;

    // Ensure newsletter is strictly higher if they were equal (unlikely with > check) 
    // or just swap them.

    $news->save();
    $newsletter->save();

    echo "New Order:\n";
    foreach (PageSection::where('page_id', 1)->orderBy('order')->get() as $s) {
        echo "{$s->section_identifier}: {$s->order}\n";
    }
} else {
    echo "\nOrder is already correct (Newsletter >= News) or items missing.\n";
}
