<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\TeamMember;

class TeamSeeder extends Seeder
{
    public function run()
    {
        // Using UI Avatars as placeholders since scraping images was blocked.
        // User can replace these in Admin Panel.

        $members = [
            // Executive Board
            [
                'name' => 'Mr. Mohamed Bin Ghanem Al Kuwari',
                'slug' => 'mr-mohamed-bin-ghanem-al-kuwari',
                'title' => 'Co - President',
                'type' => 'executive',
                'email' => 'mohamed.ghanim@tamio-capital.com',
                'phone' => '+49 1514 0577780',
                'bio' => '<p>Visionary Chairman with a proven record of leadership across engineering, construction, trading, and environmental technologies. Renowned for driving strategic growth, international partnerships, and large-scale industrial and infrastructure projects across the Middle East, Europe, and Africa.</p>',
                'sort_order' => 1
            ],
            [
                'name' => 'Dr. Sami Kassem',
                'slug' => 'dr-sami-kassem',
                'title' => 'President & CEO Founder',
                'type' => 'executive',
                'email' => 'sami.kassem@tamio-capital.com',
                'bio' => '<p>President & CEO Founder of Tamio Capital.</p>',
                'sort_order' => 2
            ],
            [
                'name' => 'Mr. Peter J. Locks',
                'slug' => 'mr-peter-john-locks',
                'title' => 'Vice President',
                'type' => 'executive',
                'email' => 'peter.locks@tamio-capital.com',
                'bio' => '<p>Vice President of Tamio Capital.</p>',
                'sort_order' => 3
            ],
            [
                'name' => 'Mr. Bent Diederichsen',
                'slug' => 'mr-bent-diederichsen',
                'title' => 'Executive Board Member',
                'type' => 'executive',
                'email' => 'bent.diederichsen@tamio-capital.com',
                'phone' => '+49 1514 0177733',
                'bio' => '<p>Extensive international experience in delivering large-scale engineering and infrastructure projects. A passionate entrepreneur, with extensive expertise in networking, sourcing, contracting, and driving complex projects from concept to successful completion.</p>',
                'sort_order' => 4
            ],

            // Board Members
            [
                'name' => 'Mr. Tolga Semerci',
                'slug' => 'mr-tolga-semerci',
                'title' => 'Board Member',
                'type' => 'team',
                'bio' => '<p>Board Member.</p>',
                'sort_order' => 5
            ],
            [
                'name' => 'Mr. Dario Viscardi',
                'slug' => 'mr-dario-viscardi',
                'title' => 'Board Member',
                'type' => 'team',
                'bio' => '<p>Board Member.</p>',
                'sort_order' => 6
            ],
            [
                'name' => 'Mr. Abdelrahman Kassem',
                'slug' => 'mr-abdelrahman-kassem',
                'title' => 'Board Member',
                'type' => 'team',
                'bio' => '<p>Board Member.</p>',
                'sort_order' => 7
            ],
            [
                'name' => 'Mr. Ghanem M. Alkuwari',
                'slug' => 'mr-ghanem-m-alkuwari',
                'title' => 'Board Member',
                'type' => 'team',
                'bio' => '<p>Board Member.</p>',
                'sort_order' => 8
            ],
            [
                'name' => 'Mr. Abdulla M. Kuwari',
                'slug' => 'mr-abdulla-m-kuwari',
                'title' => 'Board Member',
                'type' => 'team',
                'bio' => '<p>Board Member.</p>',
                'sort_order' => 9
            ],
            [
                'name' => 'Mr. Rasheed M. Alkuwari',
                'slug' => 'mr-rasheed-m-alkuwari',
                'title' => 'Board Member',
                'type' => 'team',
                'bio' => '<p>Board Member.</p>',
                'sort_order' => 10
            ],
            [
                'name' => 'Mr. Fedaa Elfayoumi',
                'slug' => 'mr-fedaa-elfayoumi',
                'title' => 'Board Member',
                'type' => 'team',
                'bio' => '<p>Board Member.</p>',
                'sort_order' => 11
            ],
            [
                'name' => 'Mr. Ghad Ahmed',
                'slug' => 'mr-ghad-ahmed',
                'title' => 'Board Member',
                'type' => 'team',
                'bio' => '<p>Board Member.</p>',
                'sort_order' => 12
            ],
            [
                'name' => 'Ms. Bethany Ruiz Pagas',
                'slug' => 'ms-bethany-ruiz-pagas',
                'title' => 'Board Member',
                'type' => 'team',
                'bio' => '<p>Board Member.</p>',
                'sort_order' => 13
            ],
            [
                'name' => 'Mr. Paolo Fedeli',
                'slug' => 'mr-paolo-fedeli',
                'title' => 'Board Member',
                'type' => 'team',
                'bio' => '<p>Board Member.</p>',
                'sort_order' => 14
            ],
            [
                'name' => 'Mr. Rick Rui Huang',
                'slug' => 'mr-rick-rui-huang',
                'title' => 'Board Member',
                'type' => 'team',
                'bio' => '<p>Board Member.</p>',
                'sort_order' => 15
            ]
        ];

        foreach ($members as $data) {
            // Using UI Avatars if photo not present
            if (!isset($data['photo'])) {
                $data['photo'] = 'https://ui-avatars.com/api/?name=' . urlencode($data['name']) . '&background=random&size=500';
            }

            TeamMember::updateOrCreate(
                ['slug' => $data['slug']],
                $data
            );
        }
    }
}
