<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Service;
use Illuminate\Support\Str;

class ServiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $services = [
            [
                'title' => 'Investment Management',
                'short_description' => 'Partnering with exceptional businesses and distinguished leaders to drive growth and value. We strive to be the premier investment partner for global industrial and technology sectors.',
                'content' => '<p>Tamio Capital Corporation serves as a global industrial, technology, and investment holding company. We focus on identifying and partnering with exceptional businesses that demonstrate strong growth potential and leadership.</p><p>Our investment strategy involves a hands-on approach, working closely with management teams to unlock value through strategic initiatives, operational improvements, and financial structuring.</p>',
                'image' => 'img/bg-corporate-1-1.jpg',
                'sort_order' => 1,
            ],
            [
                'title' => 'Litigation Support & Dispute Resolution',
                'short_description' => 'Expert witness services, claims preparation, and defense for complex commercial disputes. We provide robust support for legal proceedings and settlements.',
                'content' => '<p>Our team includes contracts and commercial experts who provide top-tier litigation support. We assist in claims preparation and defense, ensuring that our clients are well-positioned in any dispute resolution scenario.</p><p>Whether serving as expert witnesses or providing strategic advisory during settlements, we bring rigorous analysis and deep industry knowledge to the table.</p>',
                'image' => 'img/bg-corporate-20-1.jpg',
                'sort_order' => 2,
            ],
            [
                'title' => 'Strategic Consulting',
                'short_description' => 'Comprehensive strategic planning and business advisory services to help corporations navigate complex market landscapes and achieve sustainable growth.',
                'content' => '<p>We help corporate clients manage events and navigate complex market dynamics. Our consulting services cover strategic planning, market analysis, and operational efficiency.</p><p>By leveraging our deep sector expertise in Technology, Security, and Military fields, we provide actionable insights that drive competitive advantage.</p>',
                'image' => 'img/bg-corporate-14-1.jpg',
                'sort_order' => 3,
            ],
            [
                'title' => 'Technology Solutions',
                'short_description' => 'Investing in and advising on cutting-edge technology implementations. We optimize digital infrastructure to enhance business performance and security.',
                'content' => '<p>Technology is at the heart of modern business transformation. We invest in and advise on the implementation of cutting-edge technology solutions.</p><p>From cybersecurity frameworks to enterprise software deployments, our focus is on optimizing digital infrastructure to enhance business performance and resilience.</p>',
                'image' => 'img/bg-corporate-20-2.jpg',
                'sort_order' => 4,
            ],
            [
                'title' => 'Financial Restructuring',
                'short_description' => 'Financial clean-up and cash flow planning to restore fiscal health. We specialize in turning around distressed assets and optimizing capital structure.',
                'content' => '<p>Financial health is paramount. We specialize in financial clean-up and cash flow planning for businesses facing fiscal challenges.</p><p>Our services include debt restructuring, working capital optimization, and turnaround strategies designed to restore stability and set the stage for future growth.</p>',
                'image' => 'img/bg-corporate-20-3.jpg',
                'sort_order' => 5,
            ],
        ];

        foreach ($services as $service) {
            Service::updateOrCreate(
                ['title' => $service['title']], // Check by title to avoid duplicates
                [
                    'slug' => Str::slug($service['title']),
                    'short_description' => $service['short_description'],
                    'content' => $service['content'],
                    'image' => $service['image'],
                    'is_active' => true,
                    'sort_order' => $service['sort_order'],
                ]
            );
        }
    }
}
