<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class PortfolioSeeder extends Seeder
{
    public function run()
    {
        // 1. Seed Categories
        $categories = ['Infrastructure', 'Energy', 'Real Estate', 'Technology'];
        $catIds = [];

        foreach ($categories as $cat) {
            $id = DB::table('portfolio_categories')->insertGetId([
                'name' => $cat,
                'slug' => Str::slug($cat),
                'created_at' => now(),
                'updated_at' => now()
            ]);
            $catIds[$cat] = $id;
        }

        // 2. Seed Companies
        $companies = [
            [
                'name' => 'SolarTech Solutions',
                'category' => 'Energy',
                'description' => 'Leading provider of photovoltaic systems for industrial applications.',
                'services' => json_encode(['Solar Installation', 'Energy Audits', 'Grid Integration']),
                'sector' => 'Renewable Energy',
            ],
            [
                'name' => 'Urban Build Corp',
                'category' => 'Infrastructure',
                'description' => 'Specializing in large-scale urban development and smart city planning.',
                'services' => json_encode(['Civil Engineering', 'Urban Planning', 'Construction Management']),
                'sector' => 'Construction',
            ],
            [
                'name' => 'Prime Estate Ventures',
                'category' => 'Real Estate',
                'description' => 'Developing premium commercial and residential properties in key European cities.',
                'services' => json_encode(['Property Development', 'Asset Management']),
                'sector' => 'Real Estate Development',
            ],
            [
                'name' => 'NextGen Logistics',
                'category' => 'Technology',
                'description' => 'AI-driven logistics and supply chain optimization platform.',
                'services' => json_encode(['Supply Chain AI', 'Fleet Management']),
                'sector' => 'Logistics Tech',
            ]
        ];

        foreach ($companies as $comp) {
            $catName = $comp['category'];
            unset($comp['category']);

            $comp['portfolio_category_id'] = $catIds[$catName] ?? null;
            $comp['slug'] = Str::slug($comp['name']);
            $comp['created_at'] = now();
            $comp['updated_at'] = now();

            DB::table('portfolio_companies')->updateOrInsert(
                ['slug' => $comp['slug']],
                $comp
            );
        }
    }
}
