<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\Page;

class PageSeeder extends Seeder
{
    public function run(): void
    {
        $pages = [
            ['title' => 'Home', 'slug' => 'home', 'template' => 'home'],
            ['title' => 'Approach', 'slug' => 'approach', 'template' => 'default'],
            ['title' => 'Portfolio', 'slug' => 'portfolio', 'template' => 'portfolio'],
            ['title' => 'Team', 'slug' => 'team', 'template' => 'team'],
            ['title' => 'Careers', 'slug' => 'careers', 'template' => 'careers'],
            ['title' => 'News', 'slug' => 'news', 'template' => 'news'],
            ['title' => 'Contact', 'slug' => 'contact', 'template' => 'contact'],
        ];

        foreach ($pages as $page) {
            DB::table('pages')->updateOrInsert(
                ['slug' => $page['slug']],
                array_merge($page, ['created_at' => now(), 'updated_at' => now()])
            );
        }

        // Seed homepage sections
        $home = Page::where('slug', 'home')->first();

        if ($home) {
            // 'home_slider' logic moved to $sections array below

            $sections = [
                [
                    'identifier' => 'home_slider',
                    'name' => 'Home Slider',
                    'content' => [
                        'slides' => [
                            [
                                'title' => 'TAMIO CAPITAL CORPORATION PRIVATE EQUITY',
                                'subtitle' => 'EMPOWERING EXCELLENCE',
                                'text' => 'We strive to be the premier investment partner for exceptional businesses and distinguished leaders.',
                                'bg_type' => 'video',
                                'video_source' => 'url',
                                'video_url' => 'https://cdn.coverr.co/videos/coverr-business-men-walking-4548/1080p.mp4',
                                'overlay_enabled' => true,
                                'overlay_color' => '#000000',
                                'overlay_opacity' => '0.4',
                                'align' => 'text-center',
                                'button_text' => 'GET STARTED',
                                'button_link' => '#',
                                'btn_style' => 'btn-primary'
                            ],
                            [
                                'title' => 'Business Consulting services located in Los Angeles, CA',
                                'subtitle' => 'Reliable Management Consulting Services',
                                'bg_type' => 'image',
                                'image' => '/img/demos/business-consulting-2/slides/slide-1.jpg',
                                'overlay_enabled' => true,
                                'overlay_color' => '#000000',
                                'overlay_opacity' => '0.3',
                                'align' => 'text-center',
                                'button_text' => 'LEARN MORE',
                                'button_link' => '#',
                                'btn_style' => 'btn-outline btn-outline-light'
                            ]
                        ]
                    ]
                ],
                [
                    'identifier' => 'home_portfolio_tabs',
                    'name' => 'Empowering Excellence (Tabs)',
                    'content' => [
                        'title' => 'Empowering Excellence',
                        'description' => 'With decades of experience, we support the growth of leaders and the companies they drive.',
                        'tabs' => [
                            [
                                'title' => 'Technology',
                                'content' => 'We invest in technology companies that are shaping the future.',
                                'image' => 'img/projects/project-1.jpg'
                            ],
                            [
                                'title' => 'Consulting',
                                'content' => 'Our consulting partners provide world-class strategic advice.',
                                'image' => 'img/projects/project-2.jpg'
                            ]
                        ]
                    ]
                ],
                [
                    'identifier' => 'home_logos_grid',
                    'name' => 'Partner Logos',
                    'content' => [
                        'logos' => [
                            'img/logos/logo-1.png',
                            'img/logos/logo-2.png',
                            'img/logos/logo-3.png',
                            'img/logos/logo-4.png',
                            'img/logos/logo-5.png',
                            'img/logos/logo-6.png'
                        ]
                    ]
                ],
                [
                    'identifier' => 'home_news_preview',
                    'name' => 'Latest News',
                    'content' => [
                        'title' => 'News',
                        'link_text' => 'View All News',
                        'link_url' => '/news'
                    ]
                ],
                [
                    'identifier' => 'home_newsletter',
                    'name' => 'Newsletter Signup',
                    'content' => [
                        'title' => 'Get the Latest from Tamio Capital',
                        'description' => 'Subscribe to our newsletter to stay up to date on our partners, portfolio, and more.'
                    ]
                ]
            ];

            $currentIdentifiers = [];
            foreach ($sections as $index => $section) {
                $home->sections()->updateOrCreate(
                    ['section_identifier' => $section['identifier']],
                    [
                        // 'name' => $section['name'], // Column does not exist
                        'order' => $index + 1,
                        'is_active' => true,
                        'content' => $section['content']
                    ]
                );
                $currentIdentifiers[] = $section['identifier'];
            }

            // Remove sections that are not in the new list (e.g., home_features_cards, home_services_intro)
            $home->sections()->whereNotIn('section_identifier', $currentIdentifiers)->delete();
        }

        // Seed Approach page sections
        $approach = Page::where('slug', 'approach')->first();
        if ($approach) {
            $approach->sections()->firstOrCreate(
                ['section_identifier' => 'about_intro'],
                [
                    'order' => 1,
                    'is_active' => true,
                    'content' => [
                        'heading' => 'Approach',
                        'subheading' => 'At Tamio Capital, we believe in a strategic, hands-on approach to business consulting...',
                        'body' => '<p class="m-0 p-0">Our process begins with a thorough analysis of your current business state...</p>
                        <ul class="list list-icons list-primary mt-4">
                            <li><i class="fas fa-check"></i> Comprehensive Business Audits</li>
                            <li><i class="fas fa-check"></i> Strategic Planning & Execution</li>
                            <li><i class="fas fa-check"></i> Operational Excellence & Optimization</li>
                        </ul>',
                        'image' => '/img/demos/business-consulting-2/bg/bg-2.jpg',
                        'stat_percent' => '89',
                        'stat_text' => 'Successful cases<br />in 15 years.'
                    ]
                ]
            );
        }

        // Seed Portfolio page sections
        $portfolio = Page::where('slug', 'portfolio')->first();
        if ($portfolio) {
            $portfolio->sections()->firstOrCreate(
                ['section_identifier' => 'portfolio_intro'],
                [
                    'order' => 1,
                    'is_active' => true,
                    'content' => [
                        'image' => '/img/demos/business-consulting-2/bg/bg-1.jpg',
                        'text' => 'We take pride in the success of our partners. Here is a selection of companies and projects we have had the privilege to work with, helping them achieve their strategic objectives and maximize their potential.'
                    ]
                ]
            );
        }

        // Seed Contact page sections
        $contact = Page::where('slug', 'contact')->first();
        if ($contact) {
            $contact->sections()->firstOrCreate(
                ['section_identifier' => 'contact_info'],
                [
                    'order' => 1,
                    'is_active' => true,
                    'content' => [
                        'phone' => '(800) 123-4567',
                        'phone_hours' => 'Mon - Sat 9:00am - 6:00pm',
                        'address' => '123 Street Name, City, Country',
                        'email' => 'business@tamio-capital.com',
                        'linkedin_url' => 'https://www.linkedin.com'
                    ]
                ]
            );
        }

        // Seed Team page sections
        $team = Page::where('slug', 'team')->first();
        if ($team) {
            $team->sections()->firstOrCreate(
                ['section_identifier' => 'team_intro'],
                [
                    'order' => 1,
                    'is_active' => true,
                    'content' => [
                        'text' => 'Meet the dedicated team behind Tamio Capital. Our experts bring years of experience in finance, strategy, and operations to deliver exceptional results for our clients.'
                    ]
                ]
            );
        }

        // Seed Careers page sections
        $careers = Page::where('slug', 'careers')->first();
        if ($careers) {
            $careers->sections()->firstOrCreate(
                ['section_identifier' => 'careers_intro'],
                [
                    'order' => 1,
                    'is_active' => true,
                    'content' => [
                        'title' => 'Join Our Team',
                        'text' => 'We are always looking for talented individuals to join our growing team. Check out our open positions below.'
                    ]
                ]
            );
        }
    }
}
