<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\NewsPost;
use App\Models\Page;
use App\Models\PageSection;

class NewsSeeder extends Seeder
{
    public function run(): void
    {
        // 1. Create News Posts
        $post1 = NewsPost::firstOrCreate(
            ['slug' => 'tamio-corporation-engages-northcroft-law'],
            [
                'title' => 'TAMIO CORPORATION – PRIVATE EQUITY GROUP ENGAGES NORTHCROFT LAW AS GLOBAL CORPORATE LAW FIRM',
                'content' => 'TAMIO Corporation – Private Equity Group is a globally focused investment firm with a long-term approach to capital appreciation. It invests in and builds world-class companies across diverse sectors, leveraging deep operational expertise and a strategic partnership model to drive sustainable growth and superior returns for its investors.

About Northcroft Law
Northcroft Law is an international law firm renowned for its commercial acuity, cross-border transactional expertise, and dispute resolution capabilities. With a client-centric approach and a network of legal specialists across the globe, the firm delivers seamless, integrated solutions to multinational corporations, financial institutions, and investment firms facing complex legal and business challenges.',
                'featured_image' => 'img/demos/business-consulting-2/blog/blog-1.png', // Placeholder or use real URL if I download it
                'published_at' => now(),
                'status' => 'published',
                'seo_title' => 'Tamio Corporation Engages Northcroft Law',
                'seo_description' => 'Tamio Corporation announces engagement of Northcroft Law as global corporate law firm.'
            ]
        );

        $post2 = NewsPost::firstOrCreate(
            ['slug' => 'how-to-grow-your-business'],
            [
                'title' => 'How to Grow your Business',
                'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc viverra lorem ipsum erat orci, ac auctor lacus tincidunt ut. In hac habitasse platea dictumst. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.',
                'featured_image' => 'img/demos/business-consulting-2/blog/blog-2.png',
                'published_at' => now()->subDays(5),
                'status' => 'published',
                'seo_title' => 'How to Grow your Business',
                'seo_description' => 'Tips on growing your business effectively.'
            ]
        );

        // 2. Ensure "home_news" section exists for Home Page
        $homePage = Page::where('slug', 'index')->orWhere('slug', 'home')->first();
        if ($homePage) {
            PageSection::firstOrCreate(
                [
                    'page_id' => $homePage->id,
                    'section_identifier' => 'home_news',
                ],
                [
                    'order' => 99, // Before Footer (usually footer is not a section but layout, so this is last section)
                    'is_active' => true,
                    'content' => [
                        'title' => 'News and Articles',
                        'subtitle' => 'Our Blog'
                    ]
                ]
            );
        }
    }
}
