<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Menu;
use App\Models\MenuItem;

class MenuSeeder extends Seeder
{
    public function run(): void
    {
        // Header Main Menu
        $header = Menu::firstOrCreate(
            ['location' => 'header'],
            ['name' => 'Main Header Menu']
        );

        if ($header->items()->count() == 0) {
            $this->createItem($header, 'Home', '/');
            $this->createItem($header, 'Approach', '/approach');
            $this->createItem($header, 'Portfolio', '/portfolio');
            $this->createItem($header, 'Team', '/team');
            $this->createItem($header, 'Careers', '/careers');
            $this->createItem($header, 'News', '/news');
            $this->createItem($header, 'Contact', '/contact');
        }

        // Footer Quick Links
        $footer = Menu::firstOrCreate(
            ['location' => 'footer_links'],
            ['name' => 'Footer Quick Links']
        );

        if ($footer->items()->count() == 0) {
            $this->createItem($footer, 'Home', '/');
            $this->createItem($footer, 'About Us', '/approach');
            $this->createItem($footer, 'Our Services', '/services'); // Placeholder
            $this->createItem($footer, 'Consultants', '/team');
            $this->createItem($footer, 'News', '/news');
        }
    }

    private function createItem($menu, $title, $url, $parent = null)
    {
        return $menu->items()->create([
            'title' => $title,
            'url' => $url,
            'parent_id' => $parent ? $parent->id : null,
            'order' => $menu->items()->count()
        ]);
    }
}
