<?php

namespace Database\Seeders;

use App\Models\Page;
use App\Models\PageSection;
use Illuminate\Database\Seeder;

class HomeServicesSectionSeeder extends Seeder
{
    public function run()
    {
        $homePage = Page::where('slug', 'home')->first();

        if ($homePage) {
            // Check if section already exists to avoid duplicates
            if (!PageSection::where('page_id', $homePage->id)->where('section_identifier', 'home_services_with_image')->exists()) {

                PageSection::create([
                    'page_id' => $homePage->id,
                    'section_identifier' => 'home_services_with_image',
                    'order' => 3, // Place after features (2)
                    'is_visible' => true,
                    'content' => [
                        'title' => 'What We Do?',
                        'subtitle' => 'OUR SERVICES',
                        'description' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi ut.',
                        'image' => 'img/demos/business-consulting-2/bg/bg-1.jpg', // Placeholder
                        'button_text' => 'FIND OUT MORE',
                        'button_link' => '#',
                    ],
                ]);
            }
        }
    }
}
