<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class HomeFeaturesOverlapSeeder extends Seeder
{
    public function run()
    {
        $page = DB::table('pages')->where('slug', 'home')->first();

        if ($page) {
            DB::table('page_sections')->insert([
                'page_id' => $page->id,
                'section_identifier' => 'home_features_overlap',
                'order' => 2, // Assuming Slider is 1
                'is_active' => true,
                'content' => json_encode([
                    'features' => [
                        [
                            'title' => 'Strategic Planning',
                            'description' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.',
                            'icon_class' => 'fas fa-chart-line',
                            'link' => '#'
                        ],
                        [
                            'title' => 'Financial Clean-Up',
                            'description' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.',
                            'icon_class' => 'fas fa-balance-scale',
                            'link' => '#'
                        ],
                        [
                            'title' => 'Cash Flow Planning',
                            'description' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.',
                            'icon_class' => 'fas fa-chart-bar',
                            'link' => '#'
                        ]
                    ]
                ]),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
