<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class GlobalSettingsSeeder extends Seeder
{
    public function run(): void
    {
        $settings = [
            ['key' => 'site_name', 'value' => 'Tamio Capital', 'group' => 'general'],
            ['key' => 'site_logo', 'value' => 'img/logo.png', 'group' => 'general'],
            ['key' => 'contact_email', 'value' => 'info@tamio-capital.com', 'group' => 'contact'],
            ['key' => 'contact_phone', 'value' => '+1 123 456 7890', 'group' => 'contact'],
            ['key' => 'contact_address', 'value' => '123 Capital St, Finance City', 'group' => 'contact'],
            ['key' => 'contact_hours', 'value' => 'Mon - Sat 9.00am - 6.00pm / Sunday - CLOSED', 'group' => 'contact'],
            ['key' => 'social_linkedin', 'value' => 'https://linkedin.com', 'group' => 'social'],
            ['key' => 'social_twitter', 'value' => 'https://twitter.com', 'group' => 'social'],
            ['key' => 'social_facebook', 'value' => 'https://facebook.com', 'group' => 'social'],
            ['key' => 'social_instagram', 'value' => 'https://instagram.com', 'group' => 'social'],
            ['key' => 'social_youtube', 'value' => 'https://youtube.com', 'group' => 'social'],
            // Header Styling Defaults
            ['key' => 'header_font_size', 'value' => '12', 'group' => 'styling'],
            ['key' => 'header_font_weight', 'value' => '600', 'group' => 'styling'],
            ['key' => 'header_text_color', 'value' => '#E36159', 'group' => 'styling'], // Defaulting to secondary color
            // Footer Styling Defaults
            ['key' => 'footer_bg_color', 'value' => '#383f48', 'group' => 'styling'], // Quaternary
            ['key' => 'footer_text_color', 'value' => '#999999', 'group' => 'styling'], // Grey
            ['key' => 'footer_title_color', 'value' => '#E36159', 'group' => 'styling'], // Secondary
            ['key' => 'footer_link_color', 'value' => '#E36159', 'group' => 'styling'], // Secondary
            ['key' => 'footer_text', 'value' => '© 2025 Tamio Capital. All rights reserved.', 'group' => 'general'],
        ];

        foreach ($settings as $setting) {
            DB::table('global_settings')->updateOrInsert(
                ['key' => $setting['key']],
                $setting
            );
        }
    }
}
