<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('widgets', function (Blueprint $table) {
            $table->id();
            $table->string('area'); // footer_col_1, footer_col_2, sidebar
            $table->string('title')->nullable();
            $table->string('type')->default('html'); // html, menu, component
            $table->longText('content')->nullable(); // For HTML content
            $table->foreignId('menu_id')->nullable()->constrained()->nullOnDelete(); // If type is menu
            $table->integer('order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('widgets');
    }
};
