<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        try {
            if (\Illuminate\Support\Facades\Schema::hasTable('global_settings')) {
                $settings = \App\Models\GlobalSetting::all()->pluck('value', 'key');
                \Illuminate\Support\Facades\View::share('globalSettings', $settings);
            }

            if (\Illuminate\Support\Facades\Schema::hasTable('menus')) {
                // Header Menu
                $headerMenu = \App\Models\Menu::where('location', 'header')->with('rootItems.children')->first();
                \Illuminate\Support\Facades\View::share('header_menu', $headerMenu);

                // Footer Menu
                $footerMenu = \App\Models\Menu::where('location', 'footer_links')->with('rootItems.children')->first();
                \Illuminate\Support\Facades\View::share('footer_menu', $footerMenu);
            }
        } catch (\Exception $e) {
            // Silence during migration/setup
        }
    }
}
