<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Menu extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'location'];

    public function items()
    {
        return $this->hasMany(MenuItem::class)->orderBy('order');
    }

    public function rootItems()
    {
        return $this->hasMany(MenuItem::class)->whereNull('parent_id')->orderBy('order')->with('children');
    }

    public static function getByName($name)
    {
        return self::where('name', $name)->with(['rootItems.children'])->first();
    }

    public static function getByLocation($location)
    {
        return self::where('location', $location)->with(['rootItems.children'])->first();
    }
}
