<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TeamController extends Controller
{
    public function index()
    {
        $page = \App\Models\Page::where('slug', 'team')->with([
            'sections' => function ($query) {
                $query->where('is_active', true)->orderBy('order');
            }
        ])->first();

        $team = \App\Models\TeamMember::orderBy('sort_order')->get();
        return view('team', compact('page', 'team'));
    }
    public function show($slug)
    {
        $member = \App\Models\TeamMember::where('slug', $slug)->firstOrFail();
        return view('team.show', compact('member'));
    }
}
