<?php

namespace App\Http\Controllers;

use Illuminate\Http\Response;
use Illuminate\Support\Facades\URL;
use App\Models\NewsPost;
use App\Models\PortfolioCompany;

class SitemapController extends Controller
{
    public function index()
    {
        $posts = \App\Models\NewsPost::where('status', 'published')->orderBy('updated_at', 'desc')->get();
        $companies = \App\Models\PortfolioCompany::orderBy('updated_at', 'desc')->get();
        $team = \App\Models\TeamMember::where('is_active', true)->orderBy('updated_at', 'desc')->get();

        $content = view('sitemap', compact('posts', 'companies', 'team'))->render();

        return response($content)->header('Content-Type', 'text/xml');
    }
}
