<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\PageSection;

class SearchController extends Controller
{
    public function index(Request $request)
    {
        $query = $request->input('q');
        $results = [];

        if ($query) {
            // Search Portfolio
            $portfolio = DB::table('portfolio_companies')
                ->where('name', 'like', "%{$query}%")
                ->orWhere('description', 'like', "%{$query}%")
                ->select('name as title', 'description', 'slug', DB::raw("'Portfolio' as type"), DB::raw("CONCAT('/portfolio/company/', slug) as url"))
                ->get();

            // Search News
            $news = DB::table('news_posts')
                ->where('title', 'like', "%{$query}%")
                ->orWhere('content', 'like', "%{$query}%")
                ->select('title', 'content as description', 'slug', DB::raw("'News' as type"), DB::raw("CONCAT('/news/', slug) as url"))
                ->get();

            // Search Pages (Basic) -- Assuming static pages for now or PageSections if indexed
            // Simple approach: predefined list or basic check
            // For now, let's just stick to DB content

            $results = $portfolio->merge($news);
        }

        return view('search', compact('results', 'query'));
    }
}
