<?php

namespace App\Http\Controllers\Public;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class NewsletterController extends Controller
{
    public function store(Request $request)
    {
        $validated = $request->validate([
            'email' => 'required|email|max:255|unique:newsletter_subscribers,email',
            'name' => 'required|string|max:255',
            'company' => 'required|string|max:255',
        ]);

        DB::table('newsletter_subscribers')->insert([
            'email' => $validated['email'],
            'name' => $validated['name'],
            'company' => $validated['company'],
            'is_active' => true,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return redirect()->back()->with('success', 'You have successfully subscribed to our newsletter!');
    }
}
