<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Page;
use App\Models\PortfolioCategory;
use App\Models\PortfolioCompany;

class PortfolioController extends Controller
{
    public function index()
    {
        $page = Page::where('slug', 'portfolio')->with([
            'sections' => function ($query) {
                $query->where('is_active', true)->orderBy('order');
            }
        ])->first();

        $categories = PortfolioCategory::orderBy('name')->get();
        $companies = PortfolioCompany::with('category')->orderBy('sort_order')->get();

        return view('portfolio', compact('page', 'categories', 'companies'));
    }

    public function show($slug)
    {
        $company = PortfolioCompany::with('category')->where('slug', $slug)->firstOrFail();
        return view('portfolio.show', compact('company'));
    }
}
