<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Page;

class PageController extends Controller
{
    public function approach()
    {
        $page = Page::where('slug', 'approach')->with([
            'sections' => function ($query) {
                $query->where('is_active', true)->orderBy('order');
            }
        ])->firstOrFail();

        return view('approach', compact('page'));
    }

    public function contact()
    {
        $page = Page::where('slug', 'contact')->with([
            'sections' => function ($query) {
                $query->where('is_active', true)->orderBy('order');
            }
        ])->firstOrFail();

        return view('contact', compact('page'));
    }

    public function show($slug)
    {
        $page = Page::where('slug', $slug)->with([
            'sections' => function ($query) {
                $query->where('is_active', true)->orderBy('order');
            }
        ])->firstOrFail();

        // Check for specific view first, else generic
        if (view()->exists($slug)) {
            return view($slug, compact('page'));
        }

        return view('page', compact('page'));
    }
}
