<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class NewsController extends Controller
{
    public function index(Request $request)
    {
        $query = DB::table('news_posts')->where('status', 'published');

        if ($request->has('s')) {
            $search = $request->input('s');
            $query->where(function ($q) use ($search) {
                $q->where('title', 'like', "%{$search}%")
                    ->orWhere('content', 'like', "%{$search}%");
            });
        }

        $posts = $query->orderBy('published_at', 'desc')->get();

        $recent_posts = DB::table('news_posts')
            ->where('status', 'published')
            ->orderBy('published_at', 'desc')
            ->limit(3)
            ->get();

        return view('news.index', compact('posts', 'recent_posts'));
    }

    public function show($slug)
    {
        $post = DB::table('news_posts')
            ->where('slug', $slug)
            ->where('status', 'published')
            ->first();

        if (!$post) {
            abort(404);
        }

        $recent_posts = DB::table('news_posts')
            ->where('status', 'published')
            ->where('id', '!=', $post->id)
            ->orderBy('published_at', 'desc')
            ->limit(3)
            ->get();

        return view('news.show', compact('post', 'recent_posts'));
    }
}
