<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Page;
use App\Models\Job;
use Illuminate\Support\Facades\Schema;

class CareerController extends Controller
{
    public function index()
    {
        $page = \App\Models\Page::where('slug', 'careers')->with([
            'sections' => function ($query) {
                $query->where('is_active', true)->orderBy('order');
            }
        ])->first();

        // Check if table exists before fetching - migration might be needed if not existing
        if (\Illuminate\Support\Facades\Schema::hasTable('career_jobs')) {
            $jobs = \App\Models\Job::where('status', 'published')->orderBy('created_at', 'desc')->get();
        } else {
            $jobs = collect([]);
        }

        return view('careers', compact('page', 'jobs'));
    }
}
