<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TeamController extends Controller
{
    public function index()
    {
        $members = DB::table('team_members')->orderBy('sort_order')->get();
        return view('admin.team.index', compact('members'));
    }

    public function create()
    {
        return view('admin.team.create');
    }

    public function store(Request $request)
    {
        $request->validate(['name' => 'required', 'title' => 'required']);
        $data = $request->except('_token', 'photo_file');
        $data['created_at'] = now();
        $data['updated_at'] = now();

        if ($request->hasFile('photo_file')) {
            $data['photo'] = '/storage/' . $request->file('photo_file')->store('uploads/team', 'public');
        } elseif ($request->filled('photo')) {
            $data['photo'] = $request->input('photo');
        }

        DB::table('team_members')->insert($data);
        return redirect()->route('admin.team.index')->with('success', 'Member added.');
    }

    public function edit($id)
    {
        $member = DB::table('team_members')->find($id);
        return view('admin.team.edit', compact('member'));
    }

    public function update(Request $request, $id)
    {
        $request->validate(['name' => 'required', 'title' => 'required']);
        $data = $request->except('_token', '_method', 'photo_file');
        $data['updated_at'] = now();

        if ($request->hasFile('photo_file')) {
            $data['photo'] = '/storage/' . $request->file('photo_file')->store('uploads/team', 'public');
        } elseif ($request->filled('photo')) {
            $data['photo'] = $request->input('photo');
        }

        DB::table('team_members')->where('id', $id)->update($data);
        return redirect()->route('admin.team.index')->with('success', 'Member updated.');
    }

    public function destroy($id)
    {
        DB::table('team_members')->delete($id);
        return redirect()->route('admin.team.index')->with('success', 'Member deleted.');
    }
}
