<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\GlobalSetting;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Storage;

class SettingController extends Controller
{
    public function edit()
    {
        $settings = GlobalSetting::all()->pluck('value', 'key');
        return view('admin.settings.edit', compact('settings'));
    }

    public function update(Request $request)
    {
        $data = $request->except(['_token', '_method', 'site_logo', 'site_favicon', 'site_logo_file', 'site_favicon_file']);

        // Handle Text/Color Settings
        foreach ($data as $key => $value) {
            GlobalSetting::setValue($key, $value);
        }

        // Handle Logo (Upload or Select)
        if ($request->hasFile('site_logo_file')) {
            $path = $request->file('site_logo_file')->store('uploads/settings', 'public');
            GlobalSetting::setValue('site_logo', '/storage/' . $path, 'image');
        } elseif ($request->filled('site_logo')) {
            GlobalSetting::setValue('site_logo', $request->input('site_logo'), 'image');
        }

        // Handle Favicon (Upload or Select)
        if ($request->hasFile('site_favicon_file')) {
            $path = $request->file('site_favicon_file')->store('uploads/settings', 'public');
            GlobalSetting::setValue('site_favicon', '/storage/' . $path, 'image');
        } elseif ($request->filled('site_favicon')) {
            GlobalSetting::setValue('site_favicon', $request->input('site_favicon'), 'image');
        }

        // Clear cache
        Cache::forget('global_settings');

        return redirect()->route('admin.settings.edit')->with('success', 'Settings updated successfully.');
    }
}
