<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class PortfolioCategoryController extends Controller
{
    public function index()
    {
        $categories = DB::table('portfolio_categories')->orderBy('name')->get();
        return view('admin.portfolio_categories.index', compact('categories'));
    }

    public function create()
    {
        return view('admin.portfolio_categories.create');
    }

    public function store(Request $request)
    {
        $request->validate(['name' => 'required']);
        DB::table('portfolio_categories')->insert([
            'name' => $request->name,
            'slug' => Str::slug($request->name),
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        return redirect()->route('admin.portfolio-categories.index')->with('success', 'Category created.');
    }

    public function edit($id)
    {
        $category = DB::table('portfolio_categories')->find($id);
        return view('admin.portfolio_categories.edit', compact('category'));
    }

    public function update(Request $request, $id)
    {
        $request->validate(['name' => 'required']);
        DB::table('portfolio_categories')->where('id', $id)->update([
            'name' => $request->name,
            'slug' => Str::slug($request->name),
            'updated_at' => now(),
        ]);
        return redirect()->route('admin.portfolio-categories.index')->with('success', 'Category updated.');
    }

    public function destroy($id)
    {
        DB::table('portfolio_categories')->delete($id);
        return redirect()->route('admin.portfolio-categories.index')->with('success', 'Category deleted.');
    }
}
