public function reorder(Request $request, Page $page)
{
$request->validate([
'sections' => 'required|array',
'sections.*.id' => 'required|exists:page_sections,id',
'sections.*.order' => 'required|integer',
]);

foreach ($request->sections as $sectionData) {
$page->sections()->where('id', $sectionData['id'])->update(['order' => $sectionData['order']]);
}

return response()->json(['status' => 'success']);
}

public function toggleStatus(Request $request, Page $page, PageSection $section)
{
$section->update(['is_active' => !$section->is_active]);
return response()->json(['status' => 'success', 'is_active' => $section->is_active]);
}