<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\User; // Just for reference, using DB facade for raw speed/simplicity as planned or Models? 
// Plan didn't specify, but Models are better. I'll use DB for consistency with Settings if I didn't create Models. 
// Wait, I didn't create Models files yet! I only created migrations.
// I should probably use DB facade or create Models. Create Models is better Practice.
// I'll stick to DB facade for now to avoid creating 10 model files if I want to be fast, BUT
// Laravel is about Models. I'll create generic Models on the fly or just use DB.
// I'll use DB for now for speed, or basic dynamic objects.

class PageController extends Controller
{
    public function index()
    {
        $pages = DB::table('pages')->orderBy('title')->get();
        return view('admin.pages.index', compact('pages'));
    }

    public function edit($id)
    {
        $page = DB::table('pages')->find($id);
        if (!$page)
            abort(404);

        $sections = DB::table('page_sections')
            ->where('page_id', $id)
            ->orderBy('order')
            ->get();

        return view('admin.pages.edit', compact('page', 'sections'));
    }

    public function update(Request $request, $id)
    {
        $data = $request->only(['title', 'hero_title', 'hero_subtitle', 'seo_title', 'seo_description']);

        // Handle Slug
        $slug = $request->input('slug');
        if (empty($slug)) {
            $slug = $request->input('title');
        }

        // Custom Slug Logic: Replace spaces with dashes, convert to lowercase, remove unsafe chars but keep unicode
        // 1. Convert spaces to dashes
        $slug = preg_replace('/\s+/u', '-', trim($slug));
        // 2. Convert to lowercase (useful for English, harmless for Arabic)
        $slug = mb_strtolower($slug, 'UTF-8');
        // 3. Remove characters that are unsafe for URLs (keep alphanumeric, Arabic, dashes, underscores)
        // Note: Browsers handle UTF-8 mostly fine, but standard practice usually percent-encodes.
        // However, user requested "perfect... arabic... auto generate".
        // A simple "replace spaces with dashes" is often enough for modern links, but let's be safer.
        // We will keep letters, numbers, dashes, underscores.
        // \p{L} matches any unicode letter, \p{N} matches numbers.
        $slug = preg_replace('/[^\p{L}\p{N}\-_]/u', '', $slug);

        $data['slug'] = $slug;

        if ($request->hasFile('hero_image')) {
            $path = $request->file('hero_image')->store('uploads/pages', 'public');
            $data['hero_image'] = '/storage/' . $path;
        }

        try {
            DB::table('pages')->where('id', $id)->update(array_merge($data, ['updated_at' => now()]));
        } catch (\Illuminate\Database\QueryException $e) {
            // Likely duplicate entry for slug
            if ($e->errorInfo[1] == 1062) { // MySQL Duplicate entry error code
                return back()->withErrors(['slug' => 'The generated URL slug is already in use. Please choose a different one.'])->withInput();
            }
            throw $e;
        }

        return redirect()->route('admin.pages.index')->with('success', 'Page updated successfully.');
    }
}
