<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpFoundation\StreamedResponse;

class NewsletterController extends Controller
{
    public function index()
    {
        $subscribers = DB::table('newsletter_subscribers')->orderByDesc('created_at')->get();
        return view('admin.newsletter.index', compact('subscribers'));
    }

    public function export()
    {
        $headers = [
            'Content-Type' => 'text/csv',
            'Content-Disposition' => 'attachment; filename="subscribers.csv"',
        ];

        $callback = function () {
            $file = fopen('php://output', 'w');
            fputcsv($file, ['ID', 'Email', 'Subscribed At']);

            $subscribers = DB::table('newsletter_subscribers')->orderByDesc('created_at')->cursor();

            foreach ($subscribers as $subscriber) {
                fputcsv($file, [$subscriber->id, $subscriber->email, $subscriber->created_at]);
            }

            fclose($file);
        };

        return new StreamedResponse($callback, 200, $headers);
    }
}
