<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class NewsController extends Controller
{
    public function index()
    {
        $posts = DB::table('news_posts')->orderByDesc('created_at')->get();
        return view('admin.news.index', compact('posts'));
    }

    public function create()
    {
        return view('admin.news.create');
    }

    public function store(Request $request)
    {
        $request->validate(['title' => 'required']);
        $data = $request->except('_token', 'featured_image_file');
        $data['slug'] = Str::slug($request->title);
        $data['created_at'] = now();
        $data['updated_at'] = now();

        if ($request->hasFile('featured_image_file')) {
            $data['featured_image'] = '/storage/' . $request->file('featured_image_file')->store('uploads/news', 'public');
        } elseif ($request->filled('featured_image')) {
            $data['featured_image'] = $request->input('featured_image');
        }

        if ($request->filled('logo')) {
            $data['logo'] = $request->input('logo');
        }

        DB::table('news_posts')->insert($data);
        return redirect()->route('admin.news.index')->with('success', 'News post created.');
    }

    public function edit($id)
    {
        $post = DB::table('news_posts')->find($id);
        return view('admin.news.edit', compact('post'));
    }

    public function update(Request $request, $id)
    {
        $request->validate(['title' => 'required']);
        $data = $request->except('_token', '_method', 'featured_image_file');
        $data['slug'] = Str::slug($request->title);
        $data['updated_at'] = now();

        if ($request->hasFile('featured_image_file')) {
            $data['featured_image'] = '/storage/' . $request->file('featured_image_file')->store('uploads/news', 'public');
        } elseif ($request->filled('featured_image')) {
            $data['featured_image'] = $request->input('featured_image');
        }

        if ($request->filled('logo')) {
            $data['logo'] = $request->input('logo');
        } else {
            $data['logo'] = null;
        }

        DB::table('news_posts')->where('id', $id)->update($data);
        return redirect()->route('admin.news.index')->with('success', 'News post updated.');
    }

    public function destroy($id)
    {
        DB::table('news_posts')->delete($id);
        return redirect()->route('admin.news.index')->with('success', 'News post deleted.');
    }
}

class NewsletterController extends Controller
{
    public function index()
    {
        $subscribers = DB::table('newsletter_subscribers')->orderByDesc('created_at')->get();
        return view('admin.newsletter.index', compact('subscribers'));
    }

    public function export()
    {
        // Simple CSV export logic
        $headers = [
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=subscribers.csv",
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        ];

        $columns = ['Email', 'Subscribed At'];
        $callback = function () use ($columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            $subscribers = DB::table('newsletter_subscribers')->orderByDesc('created_at')->cursor();
            foreach ($subscribers as $sub) {
                fputcsv($file, [$sub->email, $sub->created_at]);
            }
            fclose($file);
        };

        return response()->stream($callback, 200, $headers);
    }
}
