<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class JobController extends Controller
{
    public function index()
    {
        $jobs = DB::table('career_jobs')->orderByDesc('created_at')->get();
        return view('admin.careers.jobs.index', compact('jobs'));
    }

    public function create()
    {
        return view('admin.careers.jobs.create');
    }

    public function store(Request $request)
    {
        $request->validate(['title' => 'required']);
        $data = $request->except('_token');
        $data['slug'] = Str::slug($request->title);
        $data['created_at'] = now();
        $data['updated_at'] = now();

        DB::table('career_jobs')->insert($data);
        return redirect()->route('admin.careers.jobs.index')->with('success', 'Job posted.');
    }

    public function edit($id)
    {
        $job = DB::table('career_jobs')->find($id);
        return view('admin.careers.jobs.edit', compact('job'));
    }

    public function update(Request $request, $id)
    {
        $request->validate(['title' => 'required']);
        $data = $request->except('_token', '_method');
        $data['slug'] = Str::slug($request->title);
        $data['updated_at'] = now();

        DB::table('career_jobs')->where('id', $id)->update($data);
        return redirect()->route('admin.careers.jobs.index')->with('success', 'Job updated.');
    }

    public function destroy($id)
    {
        DB::table('career_jobs')->delete($id);
        return redirect()->route('admin.careers.jobs.index')->with('success', 'Job deleted.');
    }
}

class ApplicationController extends Controller
{
    public function index()
    {
        $applications = DB::table('job_applications')
            ->leftJoin('career_jobs', 'job_applications.career_job_id', '=', 'career_jobs.id')
            ->select('job_applications.*', 'career_jobs.title as job_title')
            ->orderByDesc('created_at')
            ->get();
        return view('admin.careers.applications.index', compact('applications'));
    }
}
