<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PortfolioCompany;
use App\Models\TeamMember;
use App\Models\NewsPost;
use App\Models\JobApplication; // Assuming this model exists or similar

class DashboardController extends Controller
{
    public function index()
    {
        $counts = [
            'portfolio' => PortfolioCompany::count(),
            'team' => TeamMember::count(),
            'news' => NewsPost::count(),
            'applications' => \Illuminate\Support\Facades\DB::table('job_applications')->count(), // Using DB directly if model unsure
        ];

        return view('admin.dashboard', compact('counts'));
    }
}
