# Tamio Capital - Corporate Website Rebuild

A modern, CMS-driven corporate website for Tamio Capital, built with Laravel 11.

## features

*   **Custom Admin Panel**: Built with Bootstrap 5 to manage all content.
*   **Dynamic Frontend**: Based on "Porto Business Consulting 2" template.
*   **Portfolio Management**: detailed case studies and categorization.
*   **Careers Portal**: Job postings and application management with file uploads.
*   **News & Blog**: Full content management for company updates.
*   **SEO Ready**: Per-page SEO titles and descriptions managed via Admin.

## Installation

1.  **Clone the repository**:
    ```bash
    git clone ...
    cd tamio-capital
    ```

2.  **Install Dependencies**:
    ```bash
    composer install
    npm install && npm run build
    ```

3.  **Environment Setup**:
    ```bash
    cp .env.example .env
    php artisan key:generate
    # Configure DB_DATABASE, DB_USERNAME, etc. in .env
    ```

4.  **Database Setup**:
    ```bash
    php artisan migrate --seed
    ```
    *   *Seeds default admin user and initial settings.*

5.  **Storage Link**:
    ```bash
    php artisan storage:link
    ```
    *   *Required for images and resumes to be accessible.*

## Usage

*   **Public Site**: `http://tamio-capital.test` (or your local domain)
*   **Admin Panel**: `http://tamio-capital.test/admin/login`
    *   **User**: `admin@tamio-capital.com`
    *   **Pass**: `password`

## Project Structure

*   **Admin Logic**: `App\Http\Controllers\Admin`
*   **Public Logic**: `App\Http\Controllers` & `App\Http\Controllers\Public`
*   **Views**: `resources/views` (split into `admin` and public root)
*   **Assets**: `public/vendor`, `public/css`, `public/js` (Porto Template assets)

## License

Private proprietary software for Tamio Capital.
